/*
Now let's see how we can set a Property...

- the Subscriber is listening for both subscribed and changed events (a space is used between event names).
- The counter Component has a method called 'getCountUp()' that returns a 'baja:StatusBoolean' Struct. The Status Boolean has a method called 'setValue()'. All of these methods are automatically generated on the fly by BajaScript by Slot introspection. This is done to make BajaScript Objects look and feel just like their Java counter parts in the Server.
- To set the value an Object Literal can be used to specify multiple arguments (i.e. first 'setValue' call) or just the value for one argument (i.e. second 'setValue' call).
- The value is 'true'. In BajaScript a JavaScript boolean maps to a 'baja:Boolean'. A JavaScript Number is a 'baja:Double'. All of the major JavaScript types map to BajaScript Types.
- Each Property has a 'getter', 'setter' and a 'getDisplay' auto-generated method. Of course, the generic 'get', 'set' and 'getDisplay' methods on baja.Complex can also be used.
*/

var sub = new baja.Subscriber();

sub.attach("subscribed changed", function() {
  baja.outln("Counter: " + this.getOutDisplay());
});

baja.Ord.make("station:|slot:/BajaScriptTutorials/Counter").get({
  ok: function (counter) {
    // Set the count up Property to true...
    counter.getCountUp().setValue({
      value: true,
      ok: function () {
        // As soon as the Property has been set to true, change it back to false
        counter.getCountUp().setValue(false);
      }
    });
  },
  subscriber: sub
});

// Note that if other students are also going through this tutorial on this Station right now, then you may see some unexpected results!
